package MatrixApriori;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Scanner;

/**
 * @author Damla Oguz
 */
class Item implements Comparable<Item> {
    public int id;
    public String name;
    public int count;
    public int idx;
    public boolean hold;

    @Override
    public int compareTo(Item i) {
        if (i.count == count) {
            return name.compareTo(i.name);
        }
        return i.count - count;
    }

    @Override
    public String toString() {
        return name + ":" + count;
    }
}

class ItemList {
    public ArrayList<Item> itemList;
    public ArrayList<Item> supportedList;

    public ItemList() {
        itemList = new ArrayList<Item>();
        supportedList = new ArrayList<Item>();
    }

    public void sortItems() {
        Collections.sort(itemList);
    }

    public void createSupportedList(int support) {
        for (int i = 0; i < itemList.size(); i++) {
            if (itemList.get(i).count >= support) {
                supportedList.add(itemList.get(i));
            }
        }
    }
}

class DBLine {
    public int tid;
    public ArrayList<Item> items;
    public int ste;
    public String itemString;

    public DBLine() {
        tid = 0;
        items = new ArrayList<Item>();
        ste = 1;
        itemString = new String();
    }

    public void setNames() {
        for (int i = 0; i < items.size(); i++) {
            itemString += "<" + items.get(i).name + ">";
        }
    }

    public void sortItems() {
        Collections.sort(items);
    }

    public void printLine() {
        System.out.print(tid + ": ");
        for (int i = 0; i < items.size(); i++) {
            System.out.print(items.get(i).name + " ");
        }
        System.out.println(" (" + itemString + ")");
    }
}

class LineDatabase {
    public ArrayList<DBLine> DBase;
    private int support;
    private boolean isSorted;

    public LineDatabase() {
        DBase = new ArrayList<DBLine>();
        support = 0;
        isSorted = false;
    }

    public void sortLineItems() {
        for (int i = 0; i < DBase.size(); i++) {
            DBase.get(i).sortItems();
        }
        isSorted = true;
    }

    public void printDb() {
        for (int i = 0; i < DBase.size(); i++) {
            DBase.get(i).printLine();
        }
    }

    public void setNames() {
        if (!isSorted) {
            sortLineItems();
        }
        for (int i = 0; i < DBase.size(); i++) {
            DBase.get(i).setNames();
        }
    }

    public void calculateSupport() {
        // support = (int) Math.ceil((DBase.size() * 0.005));
        support = 5000;
    }

    public void setSupport(int s) {
        support = s;
    }

    public int getSupport() {
        return support;
    }
}

class MFILine {
    public int mid;
    public String itemString;
    public int ste;
    public ArrayList<Integer> values;

    MFILine() {
        mid = 0;
        ste = 1;
        itemString = "";
        values = new ArrayList<Integer>();
    }

    public void printLine() {
        System.out.print(mid + ": ");
        for (int i = 0; i < values.size(); i++) {
            System.out.print(values.get(i) + " ");
        }
        System.out.println(" " + ste);
    }
}

class MFI {
    public ArrayList<Item> itemSet;
    public ArrayList<MFILine> lines;
    public ArrayList<FrequentItem> freqItems;
    public int support;
    private int sayac;

    MFI(ArrayList<Item> supportedList) {
        itemSet = new ArrayList<Item>(supportedList);
        lines = new ArrayList<MFILine>();
        freqItems = new ArrayList<FrequentItem>();
        MFILine ilk = new MFILine();
        ilk.mid = 1;
        for (int i = 0; i < itemSet.size(); i++) {
            ilk.values.add(0);
        }
        lines.add(ilk);
        sayac = 1;
    }

    public void printMFI() {
        System.out.print("   ");
        for (int i = 0; i < itemSet.size(); i++) {
            System.out.print(itemSet.get(i).name + " ");
        }
        System.out.println(" STE");
        for (int i = 0; i < lines.size(); i++) {
            lines.get(i).printLine();
        }
    }

    public void createMFI(ArrayList<DBLine> dBase) {
        for (int i = 0; i < dBase.size(); i++) {
            String temp = new String();
            for (int k = 0; k < itemSet.size(); k++) {
                String kon = itemSet.get(k).name;
                if (dBase.get(i).itemString.contains(kon)) {
                    temp += "<" + kon + ">";
                }
            }
            dBase.get(i).itemString = temp;
        }

        for (int i = 0; i < dBase.size(); i++) {
            boolean yok = true;
            for (int j = 1; j < lines.size(); j++) {
                if (dBase.get(i).itemString.equals(lines.get(j).itemString)) {
                    lines.get(j).ste++;
                    yok = false;
                    break;
                }
            }

            if (yok) {
                boolean enAzBiriVar = false;
                MFILine yeni = new MFILine();
                yeni.itemString = dBase.get(i).itemString;
                for (int k = 0; k < itemSet.size(); k++) {
                    String kon = itemSet.get(k).name;
                    if (dBase.get(i).itemString.contains(kon)) {
                        yeni.values.add(1);
                        enAzBiriVar = true;
                    } else {
                        yeni.values.add(0);
                    }
                }
                if (enAzBiriVar) {
                    sayac++;
                    yeni.mid = sayac;
                    lines.add(yeni);
                }
            }
        }
    }

    public void modifyMFI() {
        for (int i = 0; i < itemSet.size(); i++) {
            int onceki = 0;
            for (int j = 1; j < lines.size(); j++) {
                if (lines.get(j).values.get(i) == 1) {
                    lines.get(onceki).values.set(i, lines.get(j).mid);
                    onceki = j;
                }
            }
        }
    }

    public void printFreqItems() {
        for (int i = 0; i < freqItems.size(); i++) {
            freqItems.get(i).printFreqItem();
        }
    }

    public void calculateFreqs() {
        freqItems.clear();
        for (int i = itemSet.size() - 1; i > 0; i--) {
            FrequentItem curr = new FrequentItem();
            curr.items.add(itemSet.get(i));
            curr.itemIds.add(i);
            curr.count = 0;
            calculateFreqs(curr, i - 1);
        }
    }

    private void calculateFreqs(FrequentItem curr, int i) {
        boolean test = true;
        if (i == 0) {
            test = false;
        }
        for (int j = i; j >= 0; j--) {
            FrequentItem c = new FrequentItem(curr);
            c.items.add(itemSet.get(j));
            c.itemIds.add(j);
            c.count = 0;
            if (countFreqs(c)) {
                if (test) {
                    calculateFreqs(c, j - 1);
                }
            }
        }
    }

    public boolean countFreqs(FrequentItem curr) {
        int satir = 0;
        boolean done = true;
        while (done) {
            int enBuyuk = lines.get(satir).values.get(curr.itemIds.get(0));
            boolean hepsiVar = true;
            for (int i = 0; i < curr.itemIds.size(); i++) {
                int c = lines.get(satir).values.get(curr.itemIds.get(i));
                if (c > enBuyuk) {
                    enBuyuk = c;
                }
                if (c == 0) {
                    hepsiVar = false;
                }
                if (c == 1) {
                    done = false;
                }
            }
            if (hepsiVar) {
                curr.count += lines.get(satir).ste;
            }
            if (done) {
                satir = enBuyuk - 1;
            }
        }
        curr.count = curr.count - 1;
        if (curr.count >= support) {
            freqItems.add(new FrequentItem(curr));
            return true;
        } else {
            return false;
        }
    }
}

class FrequentItem {
    public ArrayList<Item> items;
    public ArrayList<Integer> itemIds;
    public int count;

    FrequentItem() {
        items = new ArrayList<Item>();
        itemIds = new ArrayList<Integer>();
        count = 0;
    }

    FrequentItem(FrequentItem f) {
        items = new ArrayList<Item>(f.items);
        itemIds = new ArrayList<Integer>(f.itemIds);
        count = f.count;
    }

    void printFreqItem() {
        for (int i = items.size() - 1; i >= 0; i--) {
            System.out.print(items.get(i).name);
        }
        System.out.println(": " + count);
    }

    @Override
    public String toString() {
        String temp = "";
        for (int i = items.size() - 1; i >= 0; i--) {
            temp += items.get(i).name;
        }
        return temp + ": " + Integer.toString(count);
    }
}

public class MatrixApriori {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Please give arguments for [FILENAME] [SUPPORT]");
            return;
        }
        int argSupport = Integer.parseInt(args[1]);
        String fullFilePath = args[0];
        int ortalama = 0;
        System.out.println("MATRIX APRIORI");
        for (int ii = 0; ii < 1; ii++) {
            long start = System.currentTimeMillis();
            File dosya = new File(fullFilePath);
            ItemList itemIdList = new ItemList();
            LineDatabase db = new LineDatabase();
            try {
                Scanner in = new Scanner(dosya);
                String temp;
                boolean devam = true;
                while (in.hasNextLine() && devam) {
                    temp = in.next();
                    if (temp.equals("BEGIN_DATA")) {
                        devam = false;
                        continue;
                    }
                }
                devam = true;
                int sayac = 1;
                while (in.hasNextLine() && devam) {
                    temp = in.nextLine();
                    if (temp.equals("END_DATA")) {
                        devam = false;
                        continue;
                    }
                    if (temp.equals("")) {
                        continue;
                    }

                    DBLine lineTemp = new DBLine();
                    lineTemp.tid = sayac;

                    String[] r = temp.split(" ");
                    for (int i = 0; i < r.length; i++) {
                        int deger = Integer.parseInt(r[i]);
                        Iterator<Item> lit = itemIdList.itemList.iterator();
                        boolean varMi = false;
                        while (lit.hasNext()) {
                            Item tempIt = lit.next();
                            if (tempIt.id == deger) {
                                tempIt.count++;
                                lineTemp.items.add(tempIt);
                                varMi = true;
                            }
                        }
                        if (!varMi) {
                            Item it = new Item();
                            it.count = 1;
                            it.id = deger;
                            it.name = "<C" + deger + ">";
                            itemIdList.itemList.add(it);
                            lineTemp.items.add(it);
                        }
                    }
                    db.DBase.add(lineTemp);
                    sayac++;
                }
                in.close();
            } catch (Exception e) {
                System.out.println(e.toString());
                return;
            }
            db.sortLineItems();
            db.setNames();
            // db.calculateSupport();
            db.setSupport(argSupport);
            itemIdList.sortItems();
            itemIdList.createSupportedList(db.getSupport());
            MFI mfi = new MFI(itemIdList.supportedList);
            System.out.println("Frequent items :" + itemIdList.supportedList.size());
            mfi.support = db.getSupport();
            mfi.createMFI(db.DBase);
            mfi.modifyMFI();
            mfi.calculateFreqs();
            long end = System.currentTimeMillis();
            ortalama += (end - start);
            System.out.println("Frequent itemsets: " + mfi.freqItems.size());
            //  mfi.printFreqItems();
        }
        System.out.println("Execution time: " + (ortalama / 1));
    }
}
